<?php
require_once "config.php";
header('Content-Type: application/json; charset=utf-8');

$id = intval($_POST['id'] ?? 0);
$kode = trim($_POST['kode'] ?? '');
$nama = trim($_POST['nama'] ?? '');
$pajak = trim($_POST['pajak'] ?? '0');
$luas = trim($_POST['luas'] ?? '');
$lop = trim($_POST['lop'] ?? '');
$pemungut = trim($_POST['pemungut'] ?? '');
$status = trim($_POST['status'] ?? 'Belum');
$tanggal = $_POST['tanggal'] ?? null;
$ket = trim($_POST['ket'] ?? '');

if($kode==='' || $nama==='' || $pajak==='' || $luas==='' || $lop==='' || $pemungut===''){
  echo json_encode(["success"=>false,"message"=>"Lengkapi data wajib."]); exit;
}

try{
  if($id>0){
    $sql = "UPDATE tahun2025 SET kode=?, nama=?, pajak=?, luas=?, lop=?, pemungut=?, status=?, tanggal=?, ket=? WHERE id=?";
    $stmt = $mysqli->prepare($sql);
    $stmt->bind_param("sssssssssi", $kode,$nama,$pajak,$luas,$lop,$pemungut,$status,$tanggal,$ket,$id);
    $stmt->execute();
    echo json_encode(["success"=>true,"message"=>"Data diperbarui"]);
  }else{
    $sql = "INSERT INTO tahun2025 (kode,nama,pajak,luas,lop,pemungut,status,tanggal,ket) VALUES (?,?,?,?,?,?,?,?,?)";
    $stmt = $mysqli->prepare($sql);
    $stmt->bind_param("sssssssss", $kode,$nama,$pajak,$luas,$lop,$pemungut,$status,$tanggal,$ket);
    $stmt->execute();
    echo json_encode(["success"=>true,"message"=>"Data ditambahkan"]);
  }
}catch(Exception $e){
  echo json_encode(["success"=>false,"message"=>$e->getMessage()]);
}
