<?php include 'config.php'; include 'tgl.php';?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Laporan PBB</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
</head>
<body>
<div class="container mt-4">
  <input type="button" class="btn btn-dark" value="Kembali" onclick="javascript:history.back()">
  <br>
  <h3 class="mb-3">Laporan Data PBB</h3>

  <form method="get" class="row g-3 mb-3">
    <div class="col-md-3">
      <label class="form-label">Pemungut</label>
      <select name="pemungut" class="form-select">
        <option value="">-- Semua Pemungut --</option>
        <option>Manis</option>
        <option>Pahing</option>
        <option>Puhun</option>
        <option>Wage</option>
        <option>Kliwon</option>
        <option>Desa</option>
        <option>Kalwet</option>
        <option>Luar Desa</option>
      </select>
    </div>
    <div class="col-md-3">
      <label class="form-label">Status</label>
      <select name="status" class="form-select">
        <option value="">-- Semua Status --</option>
        <option>Belum</option>
        <option>Sudah</option>
      </select>
    </div>
    <div class="col-md-2 d-flex align-items-end">
      <button type="submit" class="btn btn-primary"><i class="bi bi-funnel"></i> Filter</button>
    </div>
    <div class="col-md-2 d-flex align-items-end">
      <a href="laporan_print.php?<?php echo http_build_query($_GET); ?>" target="_blank" class="btn btn-success">
        <i class="bi bi-printer"></i> Print
      </a>
    </div>
  </form>

  <?php
    $where = [];
    if (!empty($_GET['pemungut'])) $where[] = "pemungut='".$_GET['pemungut']."'";
    if (!empty($_GET['status'])) $where[] = "status='".$_GET['status']."'";
    $sql = "SELECT * FROM tahun2025";
    if ($where) $sql .= " WHERE ".implode(" AND ", $where);
    $sql .= " ORDER BY pemungut ASC";
    $result = $mysqli->query($sql);
  ?>

  <table class="table table-bordered table-striped" style="font-size: 15px;">
    <thead class="table-light">
      <tr>
        <th class="text-center">KODE</th>
        <th class="text-center">NAMA</th>
        <th class="text-center">PAJAK</th>
        <th class="text-center">LUAS</th>
        <th class="text-center">LETAK OBJEK PAJAK</th>
        <th class="text-center">PEMUNGUT</th>
        <th class="text-center">STATUS</th>
        <th class="text-center">TANGGAL BAYAR</th>
        <th class="text-center">KET</th>
      </tr>
    </thead>
    <tbody>
      <?php 
      $total = 0;
      while($row = $result->fetch_assoc()): 
        $total += $row['pajak'];
      ?>
      <tr>
        <td class="text-center"><?= $row['kode']; ?></td>
        <td><?= $row['nama']; ?></td>
        <td align="right"><?= number_format($row['pajak'],0,',','.'); ?></td>
        <td class="text-center"><?= $row['luas']; ?></td>
        <td><?= $row['lop']; ?></td>
        <td><?= $row['pemungut']; ?></td>
        <td class="text-center">
          <?php if($row['status']=='Belum'): ?>
            <span class="badge bg-danger">Belum</span>
          <?php else: ?>
            <span class="badge bg-info">Sudah</span>
          <?php endif; ?>
        </td>
        <td class="text-center"><?= tgl_indo($row['tanggal']); ?></td>
        <td><?= $row['ket']; ?></td>
      </tr>
      <?php endwhile; ?>
    </tbody>
    <tfoot>
      <tr>
        <th colspan="2">JUMLAH</th>
        <th colspan="7"><?= number_format($total,0,',','.'); ?></th>
      </tr>
    </tfoot>
  </table>
</div>
</body>
</html>
