<?php
require_once "config.php";
$filter = $_POST['filter'] ?? 'ALL';

$columns = ['kode','nama','pajak','luas','lop','pemungut','status','tanggal','ket','id'];

$draw   = intval($_POST['draw'] ?? 1);
$start  = intval($_POST['start'] ?? 0);
$length = intval($_POST['length'] ?? 10);

$order_col_index = intval($_POST['order'][0]['column'] ?? 5);
$order_dir = $_POST['order'][0]['dir'] ?? 'asc';
$order_col = $columns[$order_col_index] ?? 'pemungut';

$search_value = $_POST['search']['value'] ?? '';

// Base query and filter
$where = " WHERE 1=1 ";
$params = [];
$types = "";

if($filter !== 'ALL'){
    $where .= " AND pemungut = ? ";
    $params[] = $filter; $types .= "s";
}

if($search_value !== ''){
    $where .= " AND (kode LIKE CONCAT('%',?,'%') OR nama LIKE CONCAT('%',?,'%') OR lop LIKE CONCAT('%',?,'%') OR pemungut LIKE CONCAT('%',?,'%') OR status LIKE CONCAT('%',?,'%') OR ket LIKE CONCAT('%',?,'%')) ";
    for($i=0;$i<6;$i++){ $params[] = $search_value; $types .= "s"; }
}

// Total records
$totalRecords = $mysqli->query("SELECT COUNT(*) AS c FROM tahun2025")->fetch_assoc()['c'] ?? 0;

// Total filtered
$sqlCount = "SELECT COUNT(*) AS c FROM tahun2025 $where";
$stmt = $mysqli->prepare($sqlCount);
if(!empty($params)){ $stmt->bind_param($types, ...$params); }
$stmt->execute(); $res = $stmt->get_result(); $totalFiltered = $res->fetch_assoc()['c'] ?? 0;
$stmt->close();

// SUM pajak for filtered (cast numeric only)
$sqlSum = "SELECT SUM(CAST(REPLACE(REPLACE(pajak,'.',''),',','') AS DECIMAL(18,2))) AS s FROM tahun2025 $where";
$stmt = $mysqli->prepare($sqlSum);
if(!empty($params)){ $stmt->bind_param($types, ...$params); }
$stmt->execute(); $res = $stmt->get_result(); $sumPajak = $res->fetch_assoc()['s'] ?? 0;
$stmt->close();

// Data fetch
$sqlData = "SELECT id,kode,nama,pajak,luas,lop,pemungut,status,DATE_FORMAT(tanggal,'%Y-%m-%d') AS tanggal,ket FROM tahun2025 $where ORDER BY $order_col $order_dir LIMIT ?,?";
$params2 = $params; $types2 = $types . "ii"; $params2[] = $start; $params2[] = $length;
$stmt = $mysqli->prepare($sqlData);
$stmt->bind_param($types2, ...$params2);
$stmt->execute(); $res = $stmt->get_result();
$data = [];
while($row = $res->fetch_assoc()){ $data[] = $row; }
$stmt->close();

echo json_encode([
  "draw"=>$draw,
  "recordsTotal"=>intval($totalRecords),
  "recordsFiltered"=>intval($totalFiltered),
  "data"=>$data,
  "sum_pajak"=>floatval($sumPajak)
]);
