<?php
require_once "config.php";
require_once "helper.php";
$filter = $_GET['filter'] ?? 'ALL';
$filters = ["ALL","Manis","Pahing","Puhun","Wage","Kliwon","Desa","Kalwet","Luar Desa"];
if(!in_array($filter,$filters)){ $filter="ALL"; }

// Build data
$ops = ["Manis","Pahing","Puhun","Wage","Kliwon","Desa","Kalwet","Luar Desa"];
$rows = [];
foreach($ops as $o){
  foreach(["Belum","Sudah"] as $st){
    $stmt = $mysqli->prepare("SELECT COUNT(*) AS jml, COALESCE(SUM(CAST(REPLACE(REPLACE(pajak,'.',''),',','') AS DECIMAL(18,2))),0) AS total FROM tahun2025 WHERE pemungut=? AND status=?");
    $stmt->bind_param("ss",$o,$st);
    $stmt->execute(); $r = $stmt->get_result()->fetch_assoc();
    $rows[$o][$st] = $r;
  }
}
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Rekap PBB</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
<style>
body{ background:#f8fafc; }
.container-card{ max-width:1100px; }
</style>
</head>
<body class="p-3">
  <a href="index.php?filter=<?=esc($filter)?>" class="btn btn-outline-secondary mb-3"><i class="bi bi-arrow-left"></i> Kembali</a>
  <h3 class="mb-3">Rekap Total Pajak per Pemungut</h3>
  <div class="container-card mx-auto">
    <div class="row g-3">
      <?php foreach($ops as $o): 
        $belum = $rows[$o]['Belum']['total'] ?? 0;
        $sudah = $rows[$o]['Sudah']['total'] ?? 0;
        $jmlb = $rows[$o]['Belum']['jml'] ?? 0;
        $jmls = $rows[$o]['Sudah']['jml'] ?? 0;
      ?>
      <div class="col-md-6">
        <div class="card shadow-sm h-100">
          <div class="card-body">
            <h5 class="card-title"><?=esc($o)?></h5>
            <div class="d-flex justify-content-between">
              <div>
                <span class="badge bg-danger">Belum</span>
                <div>Jumlah: <strong><?=number_format($jmlb,0,',','.')?></strong></div>
                <div>Total Pajak: <strong><?=number_format($belum,0,',','.')?></strong></div>
              </div>
              <div class="text-end">
                <span class="badge bg-info text-dark">Sudah</span>
                <div>Jumlah: <strong><?=number_format($jmls,0,',','.')?></strong></div>
                <div>Total Pajak: <strong><?=number_format($sudah,0,',','.')?></strong></div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <?php endforeach; ?>
    </div>
  </div>
</body>
</html>
