<?php
require_once "config.php";
require_once "helper.php";
$filter = $_GET['filter'] ?? 'ALL';
$filters = ["ALL","Manis","Pahing","Puhun","Wage","Kliwon","Desa","Kalwet","Luar Desa"];
if(!in_array($filter,$filters)){ $filter="ALL"; }
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>PBB - Data PBB</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
<link href="https://cdn.datatables.net/v/bs5/dt-2.0.8/b-3.2.0/fh-4.0.1/r-3.0.3/datatables.min.css" rel="stylesheet"/>
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.12.4/dist/sweetalert2.all.min.js"></script>
<script src="https://cdn.datatables.net/v/bs5/dt-2.0.8/b-3.2.0/fh-4.0.1/r-3.0.3/datatables.min.js"></script>
<style>
body{ background:#f8fafc; }
.sidebar{
  width: 280px; min-height:100vh; position:fixed; top:0; left:0;
  background:#f1f5f9; border-right:1px solid #e2e8f0; padding:1rem; transition: all 0.3s;
}

/* Konten default (beri margin sesuai sidebar) */
#content {
    margin-left: 280px;
    transition: all 0.3s;
}

/* Kalau collapse */
#sidebar.collapsed {
    width: 80px;
}

#content.expanded {
    margin-left: 80px;
}

/* Sembunyikan teks judul saat collapse */
#sidebar.collapsed .sidebar-title {
  display: none;
}

/* Style menu saat collapse */
#sidebar.collapsed .nav-link {
    font-size: 12px;
    text-align: center;
    padding: 8px 0;
}

#sidebar.collapsed .nav-link i {
    display: none;
}

/* RESPONSIVE: HP / Tablet */
@media (max-width: 992px) {
  #sidebar {
    position: fixed;
    left: -220px;
    top: 0;
    height: 100%;
    z-index: 1050;
  }
  #sidebar.show {
    left: 0;
  }
  #content {
    margin-left: 0 !important;
  }
}

.sidebar .brand{ font-weight:700; font-size:1.3rem; }
.sidebar .nav-link{
  border-radius:1rem; margin-bottom:.4rem;
}
.sidebar .nav-link:hover{ background:#e2e8f0; transform: translateY(-1px); }
.sidebar .nav-link.active{ background:#0d6efd; }
.content{ margin-left:300px; padding:1.2rem; }
.badge-toggle{ cursor:pointer; }
.scroll-top{
  position: fixed; bottom: 24px; right: 24px; display:none; z-index:1050;
}
tfoot th{ background:#f8fafc; }

.table tbody tr td {
    font-size: 13px;
}
</style>
</head>
<body>

<!-- Sidebar -->
<aside class="sidebar" id="sidebar">
  <div class="d-flex align-items-center gap-2 mb-3">
    <img src="https://cdn-icons-png.flaticon.com/512/2991/2991112.png" width="32" height="32" alt="Logo" />
    <span class="brand sidebar-title">PBB</span>
  </div>
  <nav class="nav nav-pills flex-column">
    <a class="nav-link d-flex align-items-center gap-2 <?=activeMenu('ALL')?>" href="?filter=ALL"><i class="bi bi-table"></i> <span>Data PBB</span></a>
    <a class="nav-link d-flex align-items-center gap-2 <?=activeMenu('Manis')?>" href="?filter=Manis"><i class="bi bi-emoji-smile"></i> Manis</a>
    <a class="nav-link d-flex align-items-center gap-2 <?=activeMenu('Pahing')?>" href="?filter=Pahing"><i class="bi bi-sun"></i> Pahing</a>
    <a class="nav-link d-flex align-items-center gap-2 <?=activeMenu('Puhun')?>" href="?filter=Puhun"><i class="bi bi-tree"></i> Puhun</a>
    <a class="nav-link d-flex align-items-center gap-2 <?=activeMenu('Wage')?>" href="?filter=Wage"><i class="bi bi-cash-coin"></i> Wage</a>
    <a class="nav-link d-flex align-items-center gap-2 <?=activeMenu('Kliwon')?>" href="?filter=Kliwon"><i class="bi bi-calendar2-week"></i> Kliwon</a>
    <a class="nav-link d-flex align-items-center gap-2 <?=activeMenu('Desa')?>" href="?filter=Desa"><i class="bi bi-house-door"></i> Desa</a>
    <a class="nav-link d-flex align-items-center gap-2 <?=activeMenu('Kalwet')?>" href="?filter=Kalwet"><i class="bi bi-water"></i> Kalwet</a>
    <a class="nav-link d-flex align-items-center gap-2 <?=activeMenu('Luar Desa')?>" href="?filter=Luar Desa"><i class="bi bi-geo-alt"></i> Luar Desa</a>
    <hr>
    <a class="nav-link d-flex align-items-center gap-2" href="rekap.php?filter=<?=esc($filter)?>"><i class="bi bi-clipboard-data"></i> Menu Rekap</a>
    <a class="nav-link d-flex align-items-center gap-2" href="laporan.php?filter=<?=esc($filter)?>"><i class="bi bi-clipboard-data"></i> Laporan</a>
  </nav>
</aside>

<div class="content" id="content">
    <!-- Tombol Collapse -->
  <button id="toggleSidebar" class="btn btn-outline-secondary btn-sm mb-2">
    <i class="bi bi-list text-dark"></i>
  </button>
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h3 class="mb-0">Data PBB <small class="text-muted">(Filter: <?=esc($filter)?>)</small></h3>
    <div class="d-flex gap-2">
      <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modalForm"><i class="bi bi-plus-circle"></i> Tambah</button>
      <a class="btn btn-outline-success" id="btnExcel" href="export_excel.php?filter=<?=esc($filter)?>"><i class="bi bi-file-earmark-excel"></i> Export Excel</a>
      <a class="btn btn-outline-danger" id="btnPDF" href="export_pdf.php?filter=<?=esc($filter)?>"><i class="bi bi-file-earmark-pdf"></i> Export PDF</a>
    </div>
  </div>

  <div class="card shadow-sm">
    <div class="card-body">
      <div class="table-responsive">
        <table id="tbl" class="table table-striped table-hover table-bordered align-middle w-100">
          <thead class="table-light" style="font-size: 13px;">
            <tr>
              <th width="8%">KODE</th>
              <th>NAMA</th>
              <th>PAJAK</th>
              <th>LUAS</th>
              <th>LETAK OBJEK PAJAK</th>
              <th>PEMUNGUT</th>
              <th>STATUS</th>
              <th>TANGGAL</th>
              <th>KETERANGAN</th>
              <th>OPSI</th>
            </tr>
          </thead>
          <tfoot>
            <tr>
              <th id="tfoot-total" colspan="9" class="text-start"></th>
            </tr>
          </tfoot>
        </table>
      </div>
    </div>
  </div>
</div>

<!-- Scroll to top -->
<button class="btn btn-primary rounded-circle shadow scroll-top" id="scrollTop"><i class="bi bi-arrow-up"></i></button>

<!-- Modal Form -->
<div class="modal fade" id="modalForm" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-scrollable">
    <div class="modal-content">
      <form id="formData">
        <div class="modal-header">
          <h5 class="modal-title">Tambah / Ubah Data</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <input type="hidden" name="id" id="id">
          <div class="row g-3">
            <div class="col-md-4">
              <label class="form-label">Kode</label>
              <input type="text" class="form-control" name="kode" id="kode" required maxlength="10">
            </div>
            <div class="col-md-8">
              <label class="form-label">Nama</label>
              <input type="text" class="form-control" name="nama" id="nama" required maxlength="50">
            </div>
            <div class="col-md-4">
              <label class="form-label">Pajak</label>
              <input type="text" class="form-control" name="pajak" id="pajak" required maxlength="20">
            </div>
            <div class="col-md-4">
              <label class="form-label">Luas</label>
              <input type="text" class="form-control" name="luas" id="luas" required maxlength="20">
            </div>
            <div class="col-md-4">
              <label class="form-label">Letak Objek Pajak</label>
              <input type="text" class="form-control" name="lop" id="lop" required maxlength="50">
            </div>
            <div class="col-md-4">
              <label class="form-label">Pemungut</label>
              <select class="form-select" name="pemungut" id="pemungut" required>
                <?= pemungutOptions() ?>
              </select>
            </div>
            <div class="col-md-4">
              <label class="form-label">Status</label>
              <select class="form-select" name="status" id="status" required>
                <?= statusOptions() ?>
              </select>
            </div>
            <div class="col-md-4">
              <label class="form-label">Tanggal</label>
              <input type="date" class="form-control" name="tanggal" id="tanggal">
            </div>
            <div class="col-12">
              <label class="form-label">Keterangan</label>
              <textarea class="form-control" name="ket" id="ket" rows="2"></textarea>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
          <button class="btn btn-primary" type="submit"><i class="bi bi-save2"></i> Simpan</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
const FILTER = <?= json_encode($filter) ?>;
$(function(){
  // Scroll to top
  const $btn = $("#scrollTop");
  $(window).on("scroll", function(){ $(this).scrollTop()>200 ? $btn.fadeIn() : $btn.fadeOut(); });
  $btn.on("click", function(){ $("html,body").animate({scrollTop:0}, 400); });

  // Init DataTable server-side
  let table = $('#tbl').DataTable({
    serverSide: true,
    processing: true,
    fixedHeader: true,
    order: [[5,'asc']], // by pemungut
    lengthMenu: [[10,25,50,100,-1],[10,25,50,100]],
    // lengthMenu: [[10,25,50,100,-1],[10,25,50,100,"Semua"]],
    ajax: {
      url: 'server.php',
      type: 'POST',
      data: function(d){ d.filter = FILTER; }
    },
    columns: [
      { data: 'kode' },
      { data: 'nama' },
      { data: 'pajak',
        render: function(data){ return new Intl.NumberFormat('id-ID').format(parseFloat(data||0)); },
        className: 'text-end'
      },
      { data: 'luas' },
      { data: 'lop' },
      { data: 'pemungut' },
      { data: 'status',
        render: function(data, type, row){
          const cls = (data==='Sudah') ? 'bg-info' : 'bg-danger';
          const text = (data==='Sudah') ? 'Sudah' : 'Belum';
          return `<span class="badge ${cls} badge-toggle" data-id="${row.id}" role="button">${text}</span>`;
        },
        className: 'text-center'
      },
      { data: "tanggal", render: function(data,type,row){
        return `<input type="date" class="form-control form-control-sm update-tanggal" data-id="${row.id}" value="${data || ''}" />`;
      }},
      { data: 'ket' },
      { data: null, orderable:false, searchable:false,
        render: function(data, type, row){
          return `
            <div class="d-flex gap-2 justify-content-center">
              <button class="btn btn-sm btn-outline-secondary" data-bs-toggle="tooltip" data-bs-title="Ubah Data" onclick='editRow(${JSON.stringify(row)})'><i class="bi bi-pencil"></i></button>
              <button class="btn btn-sm btn-outline-danger" data-bs-toggle="tooltip" data-bs-title="Hapus Data" onclick="delRow(${row.id})"><i class="bi bi-trash"></i></button>
            </div>`;
        },
        className: 'text-center'
      }
    ],
    drawCallback: function(settings){
      // tooltips
      var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
      tooltipTriggerList.map(function (tooltipTriggerEl) { return new bootstrap.Tooltip(tooltipTriggerEl) })
      // footer jumlah pajak (server sends sum_pajak)
      let json = settings.json || {};
      let sum = json.sum_pajak || 0;
      $('#tfoot-total').text('Total Pajak: ' + new Intl.NumberFormat('id-ID').format(parseFloat(sum)));
    }
  });

  // Toggle status click
  $('#tbl').on('click', '.badge-toggle', function(){
    const id = $(this).data('id');
    $.post('toggle_status.php', {id:id}, function(res){
      if(res.success){ table.ajax.reload(null,false); }
      else{ Swal.fire('Gagal', res.message||'Gagal mengubah status','error'); }
    },'json').fail(function(){
      Swal.fire('Error','Gagal komunikasi server','error');
    });
  });

  // Update tanggal langsung
$(document).on("change", ".update-tanggal", function(){
    let id = $(this).data("id");
    let tanggal = $(this).val();
    $.post("update_tanggal.php", { id:id, tanggal:tanggal }, function(resp){
        if(resp.success){
            Swal.fire("Sukses","Tanggal berhasil diubah!","success");
            table.ajax.reload(null,false);
        } else {
            Swal.fire("Gagal","Tanggal gagal diubah!","error");
        }
    }, "json");
});


  // Submit form add/update
  $('#formData').on('submit', function(e){
    e.preventDefault();
    $.ajax({
      url:'save.php',
      method:'POST',
      data: $(this).serialize(),
      dataType:'json',
      success: function(res){
        if(res.success){
          $('#modalForm').modal('hide');
          $('#formData')[0].reset();
          Swal.fire('Berhasil', res.message||'Data tersimpan','success');
          table.ajax.reload(null,false);
        }else{
          Swal.fire('Gagal', res.message||'Gagal menyimpan data','error');
        }
      },
      error: function(){ Swal.fire('Error','Gagal komunikasi server','error'); }
    });
  });
});

function editRow(row){
  $('#id').val(row.id);
  $('#kode').val(row.kode);
  $('#nama').val(row.nama);
  $('#pajak').val(row.pajak);
  $('#luas').val(row.luas);
  $('#lop').val(row.lop);
  $('#pemungut').val(row.pemungut);
  $('#status').val(row.status);
  $('#tanggal').val(row.tanggal);
  $('#ket').val(row.ket);
  var mdl = new bootstrap.Modal(document.getElementById('modalForm'));
  mdl.show();
}
function delRow(id){
  Swal.fire({
    title:'Hapus data?',
    text:'Tindakan ini tidak dapat dibatalkan.',
    icon:'warning', showCancelButton:true, confirmButtonText:'Hapus', cancelButtonText:'Batal'
  }).then(function(r){
    if(r.isConfirmed){
      $.post('delete.php',{id:id}, function(res){
        if(res.success){
          Swal.fire('Berhasil','Data dihapus','success'); $('#tbl').DataTable().ajax.reload(null,false);
        }else{ Swal.fire('Gagal', res.message||'Gagal menghapus','error'); }
      },'json').fail(function(){ Swal.fire('Error','Gagal komunikasi server','error'); });
    }
  });
}

$(document).ready(function(){
  // Collapse di laptop/PC
  $("#toggleSidebar").on("click", function(){
    if (window.innerWidth >= 992) {
      $("#sidebar").toggleClass("collapsed");
      $("#content").toggleClass("expanded");
    } else {
      // Untuk HP/Tablet: slide in/out
      $("#sidebar").toggleClass("show");
    }
  });
});

</script>
</body>
</html>
