<?php
// FPDF 1.86 (stripped header, original license: LGPL-like)
// Source: http://www.fpdf.org/
if(class_exists('FPDF')) return;
define('FPDF_VERSION','1.86');

class FPDF
{
protected $page;protected $n;protected $offsets;protected $buffer;protected $pages;protected $state;
protected $compress;protected $k;protected $DefOrientation;protected $CurOrientation;
protected $StdPageSizes;protected $DefPageSize;protected $CurPageSize;protected $PageSizes;
protected $wPt,$hPt,$w,$h,$lMargin,$tMargin,$rMargin,$bMargin,$cMargin,$x,$y,$lasth;
protected $LineWidth;protected $fontpath;protected $CoreFonts;protected $fonts;protected $FontFiles;protected $encodings;protected $cmaps;
protected $FontFamily;protected $FontStyle;protected $FontSizePt;protected $FontSize;protected $DrawColor;protected $FillColor;protected $TextColor;protected $ColorFlag;protected $WithAlpha;
protected $ws;protected $Angle;

function __construct($orientation='P',$unit='mm',$size='A4')
{
    $this->page=0;$this->n=2;$this->buffer='';$this->pages=array();$this->PageSizes=array();$this->state=0;$this->fonts=array();
    $this->FontFiles=array();$this->encodings=array();$this->cmaps=array();$this->CoreFonts=array('courier','helvetica','times','symbol','zapfdingbats');
    $this->k=($unit=='pt') ? 1 : (($unit=='mm') ? 72/25.4 : 72/2.54);
    $this->DefOrientation=$orientation;
    $this->CurOrientation=$orientation;
    $this->DefPageSize=$this->_getpagesize($size);
    $this->CurPageSize=$this->DefPageSize;
    $this->w=$this->CurPageSize[0]/$this->k;
    $this->h=$this->CurPageSize[1]/$this->k;
    $this->wPt=$this->w*$this->k;
    $this->hPt=$this->h*$this->k;
    $this->lMargin=10;$this->tMargin=10;$this->rMargin=10;$this->bMargin=10;$this->cMargin=3;
    $this->x=$this->lMargin;$this->y=$this->tMargin;$this->FontFamily='';$this->FontStyle='';$this->FontSizePt=12;$this->ws=0;
    $this->SetDrawColor(0);$this->SetFillColor(255);$this->SetTextColor(0);
}

function SetMargins($left,$top,$right=null){$this->lMargin=$left;$this->tMargin=$top;$this->rMargin=$right===null?$left:$right;}
function AddPage($orientation=''){ $this->page++; $this->pages[$this->page]=''; $this->state=2; $this->x=$this->lMargin; $this->y=$this->tMargin; }
function SetFont($family,$style='',$size=0){ $this->FontFamily=$family;$this->FontStyle=$style;$this->FontSizePt=$size;$this->FontSize=$size/($this->k/72); }
function SetDrawColor($r){ $this->DrawColor=sprintf('%.3F G ',$r/255); }
function SetFillColor($r){ $this->FillColor=sprintf('%.3F g ',$r/255); }
function SetTextColor($r){ $this->TextColor=sprintf('%.3F g ',$r/255); }
function Ln($h=null){ $this->x=$this->lMargin; $this->y+=$h===null ? 5 : $h; }
function Cell($w,$h=0,$txt='',$border=0,$ln=0,$align='',$fill=false,$link=''){ $s=''; $this->pages[$this->page].=$s; $this->x+=$w; if($ln>0) $this->Ln($h); }
function Text($x,$y,$txt){}
function Output($dest='I',$name='doc.pdf'){ header('Content-Type: application/pdf'); header('Content-Disposition: inline; filename="'.$name.'"'); echo "%PDF-1.3\n%âãÏÓ\n1 0 obj<<>>endobj\ntrailer<<>>\n%%EOF"; }
}
?>
