<?php
require_once "config.php";
require_once "fpdf.php";

$filter = $_GET['filter'] ?? 'ALL';

$cond = "";
$params = [];
$types = "";
if($filter !== 'ALL'){ $cond = " WHERE pemungut=?"; $params[]=$filter; $types.="s"; }

$sql = "SELECT kode,nama,pajak,luas,lop,pemungut,status,ket FROM tahun2025".$cond." ORDER BY pemungut ASC";
$stmt = $mysqli->prepare($sql);
if(!empty($params)) $stmt->bind_param($types, ...$params);
$stmt->execute();
$res = $stmt->get_result();
$rows = $res->fetch_all(MYSQLI_ASSOC);

header('Content-Type: application/pdf');
header('Content-Disposition: attachment; filename="pbb-'.($filter==='ALL'?'Semua':$filter).'.pdf"');

echo "%PDF-1.1\n"; // super-minimalistic table-export; render as plain text PDF
echo "1 0 obj<</Type/Catalog/Pages 2 0 R>>endobj\n";
echo "2 0 obj<</Type/Pages/Count 1/Kids[3 0 R]>>endobj\n";
$content = "Data PBB (Filter: ".$filter.")\n\n";
$content .= "KODE | NAMA | PAJAK | LUAS | LOP | PEMUNGUT | STATUS | KET\n";
$content .= str_repeat("-",90)."\n";
foreach($rows as $r){
  $content .= "{$r['kode']} | {$r['nama']} | {$r['pajak']} | {$r['luas']} | {$r['lop']} | {$r['pemungut']} | {$r['status']} | {$r['ket']}\n";
}
$text = "(" . str_replace([")","("],["\\)","\\("], $content) . ") Tj\n";
$stream = "BT /F1 10 Tf 50 780 Td ".$text." ET";
$len = strlen($stream);
echo "4 0 obj<</Length $len>>stream\n$stream\nendstream endobj\n";
echo "3 0 obj<</Type/Page/Parent 2 0 R/MediaBox[0 0 595 842]/Resources<</Font<</F1<</Type/Font/Subtype/Type1/BaseFont/Helvetica>>>>>>/Contents 4 0 R>>endobj\n";
echo "xref\n0 5\n0000000000 65535 f \n";
echo "trailer<</Size 5/Root 1 0 R>>\nstartxref\n0\n%%EOF";
