<?php
// Koneksi database
$host = "localhost";
$user = "root";
$pass = "";
$db   = "kwh";

$koneksi = new mysqli($host, $user, $pass, $db);
if ($koneksi->connect_error) {
    die("Koneksi gagal: " . $koneksi->connect_error);
}

// ambil dusun dari parameter GET
if (isset($_GET['dusun'])) {
    $dusun = mysqli_real_escape_string($koneksi, $_GET['dusun']);
    $query = "SELECT * FROM pendataan WHERE dusun='$dusun' ORDER BY rt ASC";
} else {
    $dusun = "desa"; // default untuk semua data
    $query = "SELECT * FROM pendataan ORDER BY rt ASC";
}

$result = mysqli_query($koneksi, $query);

// Fungsi upload file dengan format nama khusus
function uploadFile($fileInput, $prefix, $data, $folder = "uploads/") {
    if (!empty($_FILES[$fileInput]['name'])) {
        $targetDir = $folder;
        if (!is_dir($targetDir)) {
            mkdir($targetDir, 0777, true);
        }

        $ext = strtolower(pathinfo($_FILES[$fileInput]['name'], PATHINFO_EXTENSION));

        // Sanitize biar aman
        $nama   = preg_replace("/[^a-zA-Z0-9]/", "", strtolower($data['nama']));
        $nik    = preg_replace("/[^0-9]/", "", $data['nik']);
        $dusun  = preg_replace("/[^a-zA-Z0-9]/", "", strtolower($data['dusun']));
        $rt     = preg_replace("/[^0-9]/", "", $data['rt']);
        $rw     = preg_replace("/[^0-9]/", "", $data['rw']);

        // Format: nik_nama_dusun_rt_rw_tanggal_prefix.ext
        $fileName = $nik . "_" . $nama . "_" . $dusun . "_RT" . $rt . "_RW" . $rw . "_" . date("Ymd") . "_" . $prefix . "." . $ext;

        $targetFile = $targetDir . $fileName;

        if (move_uploaded_file($_FILES[$fileInput]["tmp_name"], $targetFile)) {
            return $targetFile;
        }
    }
    return null;
}

// Tambah data
if (isset($_POST['tambah'])) {
    $nik     = $_POST['nik'];
    $nama    = $_POST['nama'];
    $dusun   = $_POST['dusun'];
    $rt      = $_POST['rt'];
    $rw      = $_POST['rw'];
    $shdk    = $_POST['shdk'];
    $hp      = $_POST['hp'];
    $umkm    = $_POST['umkm'];
    $ketumkm = $_POST['ketumkm'];
    $sktm    = $_POST['sktm'];
    $srumah  = $_POST['srumah'];
    $listrik = $_POST['listrik'];
    $lat     = $_POST['lat'];
    $long    = $_POST['long'];
    $stanah  = $_POST['stanah'];
    $jtiang  = $_POST['jtiang'];
    $jrumah  = $_POST['jrumah'];
    $ket     = $_POST['ket'];
    $cek     = $_POST['cek'];

    $formData = compact("nama","nik","dusun","rt","rw");

    $foto_ktp   = uploadFile('foto_ktp', 'ktp', $formData);
    $foto_sktm  = uploadFile('foto_sktm', 'sktm', $formData);
    $foto_rumah = uploadFile('foto_rumah', 'rumah', $formData);
    $file_tanah = uploadFile('file_tanah', 'tanah', $formData);

    $sql = "INSERT INTO pendataan 
        (nik, nama, dusun, rt, rw, foto_ktp, shdk, hp, umkm, ketumkm, sktm, foto_sktm, srumah, listrik, foto_rumah, lat, `long`, stanah, file_tanah, jtiang, jrumah, ket, cek)
        VALUES
        ('$nik','$nama','$dusun','$rt','$rw','$foto_ktp','$shdk','$hp','$umkm','$ketumkm','$sktm','$foto_sktm','$srumah','$listrik','$foto_rumah','$lat','$long','$stanah','$file_tanah','$jtiang','$jrumah','$ket','$cek')";
    $koneksi->query($sql);
    header("Location: index.php?status=added");
    exit;
}

// Ubah data
if (isset($_POST['ubah'])) {
    $id      = $_POST['id'];
    $nik     = $_POST['nik'];
    $nama    = $_POST['nama'];
    $dusun   = $_POST['dusun'];
    $rt      = $_POST['rt'];
    $rw      = $_POST['rw'];
    $shdk    = $_POST['shdk'];
    $hp      = $_POST['hp'];
    $umkm    = $_POST['umkm'];
    $ketumkm = $_POST['ketumkm'];
    $sktm    = $_POST['sktm'];
    $srumah  = $_POST['srumah'];
    $listrik = $_POST['listrik'];
    $lat     = $_POST['lat'];
    $long    = $_POST['long'];
    $stanah  = $_POST['stanah'];
    $jtiang  = $_POST['jtiang'];
    $jrumah  = $_POST['jrumah'];
    $ket     = $_POST['ket'];
    $cek     = $_POST['cek'];

    $formData = compact("nama","nik","dusun","rt","rw");

    // ambil data lama
    $q = mysqli_query($koneksi,"SELECT * FROM pendataan WHERE id='$id'");
    $d = mysqli_fetch_assoc($q);

    $foto_ktp   = !empty($_FILES['foto_ktp']['name'])   ? uploadFile('foto_ktp','ktp',$formData)   : $d['foto_ktp'];
    $foto_sktm  = !empty($_FILES['foto_sktm']['name'])  ? uploadFile('foto_sktm','sktm',$formData) : $d['foto_sktm'];
    $foto_rumah = !empty($_FILES['foto_rumah']['name']) ? uploadFile('foto_rumah','rumah',$formData): $d['foto_rumah'];
    $file_tanah = !empty($_FILES['file_tanah']['name']) ? uploadFile('file_tanah','tanah',$formData): $d['file_tanah'];

    $sql = "UPDATE pendataan SET 
        nik='$nik', nama='$nama', dusun='$dusun', rt='$rt', rw='$rw',
        shdk='$shdk', hp='$hp', umkm='$umkm', ketumkm='$ketumkm',
        sktm='$sktm', srumah='$srumah', listrik='$listrik',
        lat='$lat', `long`='$long', stanah='$stanah', jtiang='$jtiang', jrumah='$jrumah',
        ket='$ket', cek='$cek'";

    if ($foto_ktp) $sql .= ", foto_ktp='$foto_ktp'";
    if ($foto_sktm) $sql .= ", foto_sktm='$foto_sktm'";
    if ($foto_rumah) $sql .= ", foto_rumah='$foto_rumah'";
    if ($file_tanah) $sql .= ", file_tanah='$file_tanah'";

    $sql .= " WHERE id=$id";
    $koneksi->query($sql);
    header("Location: index.php?status=updated");
    exit;
}

// Hapus data
if (isset($_POST['hapus'])) {
    $id = $_POST['id'];

    // Ambil data file dari database
    $q = mysqli_query($koneksi, "SELECT foto_ktp, foto_rumah, foto_sktm, file_tanah 
                                 FROM pendataan WHERE id='$id'");
    $d = mysqli_fetch_assoc($q);

    // Hapus file satu per satu jika ada
    $fileFields = ['foto_ktp', 'foto_rumah', 'foto_sktm', 'file_tanah'];
    foreach ($fileFields as $field) {
        if (!empty($d[$field]) && file_exists($d[$field])) {
            unlink($d[$field]);
        }
    }

    // Hapus data dari database
    $hapus = mysqli_query($koneksi, "DELETE FROM pendataan WHERE id='$id'");

    if ($hapus) {
        echo "<script>
            Swal.fire({
                icon: 'success',
                title: 'Data berhasil dihapus',
                showConfirmButton: false,
                timer: 1500
            }).then(() => {
                window.location = 'index.php';
            });
        </script>";
    } else {
        echo "<script>
            Swal.fire({
                icon: 'error',
                title: 'Gagal menghapus data',
                text: '".mysqli_error($koneksi)."'
            });
        </script>";
    }
}
?>
<!doctype html>
<html lang="id">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>PEMDES KALIMANGGISKULON</title>
    <link rel="icon" type="image/png" sizes="200x200" href="img/pemdesku.png">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.min.css">
    <link href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
      body {
        overflow-x: hidden;
      }
      /*.sidebar {
        min-height: 100vh;
      }
      
      .nav-link.active {
        background-color: #0d6efd !important;
        color: #fff !important;
        border-radius: 50px;
      }
      .nav-link:hover {
        background-color: #e9ecef;
        border-radius: 50px;
      }
      .nav-link.active:hover {
        background-color: #0d6efd !important;
        color: #fff !important;
      }*/
      /* Sidebar overlay untuk layar kecil */
      /*@media (max-width: 768px) {
        #sidebarMenu {
          position: fixed;
          top: 56px;
          left: 0;
          width: 250px;
          height: 100%;
          z-index: 1030;
          background-color: #fff;
          box-shadow: 2px 0 5px rgba(0,0,0,.1);
          transform: translateX(-100%);
          transition: transform .3s ease-in-out;
        }
        #sidebarMenu.show {
          transform: translateX(0);
        }
      }*/
      .sidebar{min-height:100vh;background:#fdfdfd;box-shadow:2px 0 6px rgba(0,0,0,.08);padding:1rem}
      .sidebar .nav-link{color:#333;border-radius:.5rem;margin:.25rem 0;padding:.6rem 1rem}
      .sidebar .nav-link:hover{background:#e9ecef;color:#0d6efd}
      .sidebar .nav-link.active{background:#0d6efd;color:#fff}
      /* Default: konten geser 250px karena sidebar */
      @media (min-width: 992px) {
        #mainContent {
          margin-left: 250px;
        }
        #sidebar {
          width: 250px;
          position: fixed;
          top: 60px; /* tinggi navbar */
          left: 0;
          bottom: 0;
          overflow-y: auto;
        }
      }

      /* Mobile: konten full width, sidebar overlay */
      @media (max-width: 991.98px) {
        #mainContent {
          margin-left: 0 !important;
        }
        #sidebar {
          position: fixed;
          top: 65px;
          left: 0;
          bottom: 0;
          width: 250px;
          z-index: 1050;
          background: #fff;
          box-shadow: 2px 0 6px rgba(0,0,0,.2);
        }
      }
    </style>
  </head>
  <body>
    <!-- Navbar -->
    <nav class="navbar navbar-light bg-light shadow-sm sticky-top">
      <div class="container-fluid d-flex justify-content-between">
        <div class="d-flex align-items-center">
          <img src="img/logo.png" alt="Logo" width="40" class="me-2">
          <div>
            <div class="fw-bold">PEMDES KALIMANGGISKULON</div>
            <small class="text-muted" style="font-size: 13px;">KECAMATAN KALIMANGGIS KABUPATEN KUNINGAN</small>
          </div>
        </div>
        <!-- Toggle Sidebar (hanya muncul di layar kecil) -->
        <button class="btn btn-outline-primary d-md-none" type="button" id="sidebarToggle">
          ☰
        </button>
      </div>
    </nav>

    <div class="container-fluid">
      <div class="row">
        <!-- Sidebar -->
       <aside id="sidebar" class="collapse d-lg-block col-md-2 sidebar">
          <ul class="nav flex-column">
            <li class="nav-item mb-2">
              <a class="nav-link d-flex align-items-center <?= !isset($_GET['dusun']) ? 'active bg-primary text-white rounded-pill shadow' : '' ?>" href="index.php">
                <span>Data Desa</span>
              </a>
            </li>
            <li class="nav-item mb-2">
              <a class="nav-link d-flex align-items-center <?= (isset($_GET['dusun']) && $_GET['dusun']=='Manis') ? 'active bg-primary text-white rounded-pill shadow' : '' ?>" href="index.php?dusun=Manis">
                <span>Dusun Manis</span>
              </a>
            </li>
            <li class="nav-item mb-2">
              <a class="nav-link d-flex align-items-center <?= (isset($_GET['dusun']) && $_GET['dusun']=='Pahing') ? 'active bg-primary text-white rounded-pill shadow' : '' ?>" href="index.php?dusun=Pahing">
                <span>Dusun Pahing</span>
              </a>
            </li>
            <li class="nav-item mb-2">
              <a class="nav-link d-flex align-items-center <?= (isset($_GET['dusun']) && $_GET['dusun']=='Puhun') ? 'active bg-primary text-white rounded-pill shadow' : '' ?>" href="index.php?dusun=Puhun">
                <span>Dusun Puhun</span>
              </a>
            </li>
            <li class="nav-item mb-2">
              <a class="nav-link d-flex align-items-center <?= (isset($_GET['dusun']) && $_GET['dusun']=='Wage') ? 'active bg-primary text-white rounded-pill shadow' : '' ?>" href="index.php?dusun=Wage">
                <span>Dusun Wage</span>
              </a>
            </li>
            <li class="nav-item mb-2">
              <a class="nav-link d-flex align-items-center <?= (isset($_GET['dusun']) && $_GET['dusun']=='Kliwon') ? 'active bg-primary text-white rounded-pill shadow' : '' ?>" href="index.php?dusun=Kliwon">
                <span>Dusun Kliwon</span>
              </a>
            </li>
          </ul>
        </aside>

        <!-- Konten -->
        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 mt-4">
          <div class="card shadow-sm">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0 text-uppercase"><?= isset($_GET['dusun']) ? "Data Yang Belum Memiliki kWh Dusun ".$_GET['dusun'] : "Data Yang Belum Memiliki kWh Desa Kalimanggiskulon" ?></h5>
                <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#modalTambah">+ Tambah Data</button>
            </div>
            <div class="card-body">
              <a href="print.php?dusun=<?= $dusun; ?>" target="_blank" class="btn btn-dark btn-sm">
                <i class="bi bi-printer text-white"></i> Print
              </a>
              <br><br>
              <div class="table-responsive">
                <table id="tabel" class="table table-bordered table-striped">
                  <thead>
                    <tr>
                      <th class="text-center">NO</th>
                      <th class="text-center">NIK</th>
                      <th class="text-center">NAMA</th>
                      <th class="text-center">DUSUN</th>
                      <th class="text-center">RT</th>
                      <th class="text-center">RW</th>
                      <th class="text-center">CEK</th>
                      <th class="text-center">OPSI</th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php
                    $no=1;
                      // cek filter
                      if (isset($_GET['dusun'])) {
                          $dusun = mysqli_real_escape_string($koneksi, $_GET['dusun']);
                          $query = "SELECT * FROM pendataan WHERE dusun='$dusun' ORDER BY rt, nama ASC";
                      } else {
                          $query = "SELECT * FROM pendataan ORDER BY rt, nama ASC";
                      }

                      $result = mysqli_query($koneksi, $query);
                      while ($row=mysqli_fetch_assoc($result)) {
                    ?>
                    <tr>
                      <td class="text-center"><?= $no++ ?></td>
                      <td class="text-center"><?= $row['nik'] ?></td>
                      <td><?= $row['nama'] ?></td>
                      <td class="text-uppercase"><?= $row['dusun'] ?></td>
                      <td class="text-center"><?= $row['rt'] ?></td>
                      <td class="text-center"><?= $row['rw'] ?></td>
                      <td class="text-center text-uppercase"><?= $row['cek'] ?></td>
                      <td class="text-center">
                        <button class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#modalDetail<?= $row['id'] ?>">Detail</button>
                        <button class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#modalUbah<?= $row['id']; ?>">Ubah</button>
                        <button class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#modalHapus<?= $row['id']; ?>">Hapus</button>
                      </td>
                    </tr>
                      <!-- Modal Detail -->
                      <div class="modal fade" id="modalDetail<?= $row['id'] ?>" tabindex="-1">
                        <div class="modal-dialog modal-lg">
                          <div class="modal-content">
                            <div class="modal-header bg-info text-white">
                              <h5 class="modal-title">Detail Data</h5>
                              <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                            </div>
                            <div class="modal-body">

                              <!-- NIK & Nama -->
                              <div class="row">
                                <div class="col-md-6 mb-3">
                                  <label class="form-label">NIK</label>
                                  <input type="text" class="form-control" value="<?= $row['nik'] ?>" readonly>
                                </div>
                                <div class="col-md-6 mb-3">
                                  <label class="form-label">Nama</label>
                                  <input type="text" class="form-control" value="<?= $row['nama'] ?>" readonly>
                                </div>
                              </div>

                              <!-- Dusun, RT, RW -->
                              <div class="row">
                                <div class="col-md-4 mb-3">
                                  <label class="form-label">Dusun</label>
                                  <input type="text" class="form-control" value="<?= $row['dusun'] ?>" readonly>
                                </div>
                                <div class="col-md-4 mb-3">
                                  <label class="form-label">RT</label>
                                  <input type="text" class="form-control" value="<?= $row['rt'] ?>" readonly>
                                </div>
                                <div class="col-md-4 mb-3">
                                  <label class="form-label">RW</label>
                                  <input type="text" class="form-control" value="<?= $row['rw'] ?>" readonly>
                                </div>
                              </div>

                              <!-- SHDK, HP, UMKM -->
                              <div class="row">
                                <div class="col-md-4 mb-3">
                                  <label class="form-label">SHDK</label>
                                  <input type="text" class="form-control" value="<?= $row['shdk'] ?>" readonly>
                                </div>
                                <div class="col-md-4 mb-3">
                                  <label class="form-label">No HP</label>
                                  <input type="text" class="form-control" value="<?= $row['hp'] ?>" readonly>
                                </div>
                                <div class="col-md-4 mb-3">
                                  <label class="form-label">UMKM</label>
                                  <input type="text" class="form-control" value="<?= $row['umkm'] ?>" readonly>
                                </div>
                              </div>

                              <!-- Ket UMKM, SKTM, S Rumah -->
                              <div class="row">
                                <div class="col-md-6 mb-3">
                                  <label class="form-label">Keterangan UMKM</label>
                                  <input type="text" class="form-control" value="<?= $row['ketumkm'] ?>" readonly>
                                </div>
                                <div class="col-md-3 mb-3">
                                  <label class="form-label">SKTM</label>
                                  <input type="text" class="form-control" value="<?= $row['sktm'] ?>" readonly>
                                </div>
                                <div class="col-md-3 mb-3">
                                  <label class="form-label">Status Rumah</label>
                                  <input type="text" class="form-control" value="<?= $row['srumah'] ?>" readonly>
                                </div>
                              </div>

                              <!-- Listrik, Tanah -->
                              <div class="row">
                                <div class="col-md-6 mb-3">
                                  <label class="form-label">Listrik</label>
                                  <input type="text" class="form-control" value="<?= $row['listrik'] ?>" readonly>
                                </div>
                                <div class="col-md-6 mb-3">
                                  <label class="form-label">Status Tanah</label>
                                  <input type="text" class="form-control" value="<?= $row['stanah'] ?>" readonly>
                                </div>
                              </div>

                              <!-- Koordinat -->
                              <div class="row">
                                <div class="col-md-6 mb-3">
                                  <label class="form-label">Latitude</label>
                                  <input type="text" class="form-control" value="<?= $row['lat'] ?>" readonly>
                                </div>
                                <div class="col-md-6 mb-3">
                                  <label class="form-label">Longitude</label>
                                  <input type="text" class="form-control" value="<?= $row['long'] ?>" readonly>
                                </div>
                              </div>

                              <!-- Jarak -->
                              <div class="row">
                                <div class="col-md-6 mb-3">
                                  <label class="form-label">Jarak ke Tiang (M)</label>
                                  <input type="text" class="form-control" value="<?= $row['jtiang'] ?>" readonly>
                                </div>
                                <div class="col-md-6 mb-3">
                                  <label class="form-label">Jarak ke Rumah Tetangga (M)</label>
                                  <input type="text" class="form-control" value="<?= $row['jrumah'] ?>" readonly>
                                </div>
                              </div>

                              <!-- Keterangan -->
                              <div class="mb-3">
                                <label class="form-label">Keterangan</label>
                                <textarea class="form-control" rows="3" readonly><?= $row['ket'] ?></textarea>
                              </div>

                              <!-- Cek -->
                              <div class="mb-3">
                                <label class="form-label">Cek</label>
                                <input type="text" class="form-control" value="<?= $row['cek'] ?>" readonly>
                              </div>

                              <!-- File Preview -->
                              <div class="row">
                                <div class="col-md-6 mb-3">
                                  <label class="form-label">Foto KTP</label><br>
                                  <?php if ($row['foto_ktp']): ?>
                                    <?php $ext = strtolower(pathinfo($row['foto_ktp'], PATHINFO_EXTENSION)); ?>
                                    <?php if (in_array($ext,['jpg','jpeg','png'])): ?>
                                      <img src="<?= $row['foto_ktp'] ?>" class="img-thumbnail" style="max-height:150px;">
                                    <?php else: ?>
                                      <a href="<?= $row['foto_ktp'] ?>" target="_blank" class="btn btn-primary btn-sm">Lihat PDF</a>
                                    <?php endif; ?>
                                  <?php else: ?>
                                    <span class="text-muted">Belum ada file</span>
                                  <?php endif; ?>
                                </div>
                                <div class="col-md-6 mb-3">
                                  <label class="form-label">Foto Rumah</label><br>
                                  <?php if ($row['foto_rumah']): ?>
                                    <?php $ext = strtolower(pathinfo($row['foto_rumah'], PATHINFO_EXTENSION)); ?>
                                    <?php if (in_array($ext,['jpg','jpeg','png'])): ?>
                                      <img src="<?= $row['foto_rumah'] ?>" class="img-thumbnail" style="max-height:150px;">
                                    <?php else: ?>
                                      <a href="<?= $row['foto_rumah'] ?>" target="_blank" class="btn btn-primary btn-sm">Lihat PDF</a>
                                    <?php endif; ?>
                                  <?php else: ?>
                                    <span class="text-muted">Belum ada file</span>
                                  <?php endif; ?>
                                </div>
                              </div>

                              <div class="row">
                                <div class="col-md-6 mb-3">
                                  <label class="form-label">Foto SKTM</label><br>
                                  <?php if ($row['foto_sktm']): ?>
                                    <?php $ext = strtolower(pathinfo($row['foto_sktm'], PATHINFO_EXTENSION)); ?>
                                    <?php if (in_array($ext,['jpg','jpeg','png'])): ?>
                                      <img src="<?= $row['foto_sktm'] ?>" class="img-thumbnail" style="max-height:150px;">
                                    <?php else: ?>
                                      <a href="<?= $row['foto_sktm'] ?>" target="_blank" class="btn btn-primary btn-sm">Lihat PDF</a>
                                    <?php endif; ?>
                                  <?php else: ?>
                                    <span class="text-muted">Belum ada file</span>
                                  <?php endif; ?>
                                </div>
                                <div class="col-md-6 mb-3">
                                  <label class="form-label">File Tanah</label><br>
                                  <?php if ($row['file_tanah']): ?>
                                    <?php $ext = strtolower(pathinfo($row['file_tanah'], PATHINFO_EXTENSION)); ?>
                                    <?php if (in_array($ext,['jpg','jpeg','png'])): ?>
                                      <img src="<?= $row['file_tanah'] ?>" class="img-thumbnail" style="max-height:150px;">
                                    <?php else: ?>
                                      <a href="<?= $row['file_tanah'] ?>" target="_blank" class="btn btn-primary btn-sm">Lihat PDF</a>
                                    <?php endif; ?>
                                  <?php else: ?>
                                    <span class="text-muted">Belum ada file</span>
                                  <?php endif; ?>
                                </div>
                              </div>

                            </div>
                            <div class="modal-footer">
                              <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                            </div>
                          </div>
                        </div>
                      </div>

                      <!-- Modal Ubah -->
                      <div class="modal fade" id="modalUbah<?=$row['id']?>">
                        <div class="modal-dialog modal-lg">
                          <div class="modal-content">
                            <form method="post" enctype="multipart/form-data">
                              <div class="modal-header bg-warning"><h5 class="modal-title" id="modalUbahLabel<?= $row['id']; ?>">Ubah Data</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
                              <div class="modal-body">
                                <input type="hidden" name="id" value="<?=$row['id']?>">
                                <div class="row g-2">
                                  <div class="col-md-4"><label>NIK</label><input type="text" name="nik" value="<?=$row['nik']?>" class="form-control"></div>
                                  <div class="col-md-8"><label>Nama</label><input type="text" name="nama" value="<?=$row['nama']?>" class="form-control"></div>
                                  <div class="col-md-3">
                                    <label>Dusun</label>
                                    <select name="dusun" id="dusunUbah<?= $row['id']; ?>" class="form-select" required>
                                      <option value="">-- Pilih Dusun --</option>
                                      <option value="Manis" <?= ($row['dusun']=="Manis"?"selected":""); ?>>Manis</option>
                                      <option value="Pahing" <?= ($row['dusun']=="Pahing"?"selected":""); ?>>Pahing</option>
                                      <option value="Puhun" <?= ($row['dusun']=="Puhun"?"selected":""); ?>>Puhun</option>
                                      <option value="Wage" <?= ($row['dusun']=="Wage"?"selected":""); ?>>Wage</option>
                                      <option value="Kliwon" <?= ($row['dusun']=="Kliwon"?"selected":""); ?>>Kliwon</option>
                                    </select>
                                  </div>
                                  <div class="col-md-2">
                                    <label>RT</label>
                                    <select name="rt" id="rtUbah<?= $row['id']; ?>" class="form-select" required>
                                      <option value="<?= $row['rt']; ?>"><?= $row['rt']; ?></option>
                                    </select>
                                  </div>
                                  <div class="col-md-1">
                                    <label>RW</label>
                                    <input type="text" name="rw" id="rwUbah<?= $row['id']; ?>" class="form-control" value="<?= $row['rw']; ?>" readonly>
                                  </div>
                                  <div class="col-md-3">
                                    <label>SHDK</label>
                                    <select name="shdk" class="form-select">
                                      <?php $opsi=['Kepala Keluarga','Suami','Istri','Anak','Menantu','Cucu','Orang Tua','Mertua','Famili Lain','Pembantu','Lainnya'];
                                      foreach($opsi as $o){$sel=$row['shdk']==$o?"selected":""; echo"<option $sel>$o</option>";}?>
                                    </select>
                                  </div>
                                  <div class="col-md-3"><label>HP</label><input type="text" name="hp" value="<?=$row['hp']?>" class="form-control"></div>
                                  <div class="col-md-3">
                                    <label>UMKM</label>
                                    <select name="umkm" class="form-select">
                                      <option <?=$row['umkm']=='Ya'?'selected':''?>>Ya</option>
                                      <option <?=$row['umkm']=='Tidak'?'selected':''?>>Tidak</option>
                                    </select>
                                  </div>
                                  <div class="col-md-3"><label>Keterangan UMKM</label><input type="text" name="ketumkm" value="<?=$row['ketumkm']?>" class="form-control"></div>
                                  <div class="col-md-3">
                                    <label>SKTM</label>
                                    <select name="sktm" class="form-select">
                                      <option <?=$row['sktm']=='Ada'?'selected':''?>>Ada</option>
                                      <option <?=$row['sktm']=='Tidak Ada'?'selected':''?>>Tidak Ada</option>
                                    </select>
                                  </div>
                                  <div class="col-md-3">
                                    <label>Status Rumah</label>
                                    <select name="srumah" class="form-select">
                                      <option <?=$row['srumah']=='Pribadi'?'selected':''?>>Pribadi</option>
                                      <option <?=$row['srumah']=='Sewa'?'selected':''?>>Sewa</option>
                                    </select>
                                  </div>
                                  <div class="col-md-6">
                                    <label>Listrik</label>
                                    <select name="listrik" class="form-select">
                                      <option <?=$row['listrik']=='Belum Memiliki kWh/Menyalur'?'selected':''?>>Belum Memiliki kWh/Menyalur</option>
                                      <option <?=$row['listrik']=='Belum Berlistrik'?'selected':''?>>Belum Berlistrik</option>
                                    </select>
                                  </div>
                                  <div class="col-md-3"><label>Latitude</label><input type="text" name="lat" value="<?=$row['lat']?>" class="form-control"></div>
                                  <div class="col-md-3"><label>Longitude</label><input type="text" name="long" value="<?=$row['long']?>" class="form-control"></div>
                                  <div class="col-md-3">
                                    <label>Status Tanah</label>
                                    <select name="stanah" class="form-select">
                                      <option <?=$row['stanah']=='SHM'?'selected':''?>>SHM</option>
                                      <option <?=$row['stanah']=='SPPT'?'selected':''?>>SPPT</option>
                                    </select>
                                  </div>
                                  <div class="col-md-3"><label>Jarak ke Tiang</label><input type="text" name="jtiang" value="<?=$row['jtiang']?>" class="form-control"></div>
                                  <div class="col-md-3"><label>Jarak ke Rumah</label><input type="text" name="jrumah" value="<?=$row['jrumah']?>" class="form-control"></div>
                                  <div class="col-md-3">
                                    <label>Cek</label>
                                    <select name="cek" class="form-select">
                                      <option <?=$row['cek']=='Sudah'?'selected':''?>>Sudah</option>
                                      <option <?=$row['cek']=='Belum'?'selected':''?>>Belum</option>
                                    </select>
                                  </div>
                                  <div class="col-md-12"><label>Keterangan</label><textarea name="ket" class="form-control"><?=$row['ket']?></textarea></div>

                                  <div class="col-md-6">
                                    <label>Foto KTP</label>
                                    <input type="file" class="form-control" name="foto_ktp" accept=".jpg,.jpeg,.png,.pdf" onchange="previewFile(this, 'prevKTP<?= $row['id'] ?>')">
                                    <div id="prevKTP<?= $row['id'] ?>" class="mt-2">
                                      <?php if ($row['foto_ktp']): ?>
                                        <?php $ext = strtolower(pathinfo($row['foto_ktp'], PATHINFO_EXTENSION)); ?>
                                        <?php if (in_array($ext, ['jpg','jpeg','png'])): ?>
                                          <img src="<?= $row['foto_ktp'] ?>" class="img-thumbnail" style="max-height:150px;">
                                        <?php elseif ($ext == 'pdf'): ?>
                                          <a href="<?= $row['foto_ktp'] ?>" target="_blank" class="btn btn-sm btn-primary">Lihat PDF</a>
                                        <?php endif; ?>
                                      <?php else: ?>
                                        <span class="text-muted">Belum ada file</span>
                                      <?php endif; ?>
                                    </div>
                                  </div>
                                  <div class="col-md-6">
                                    <label>Foto SKTM</label>
                                    <input type="file" class="form-control" name="foto_sktm"
                                           accept=".jpg,.jpeg,.png,.pdf" 
                                           onchange="previewFile(this, 'prevSKTM<?= $row['id'] ?>')">

                                    <div id="prevSKTM<?= $row['id'] ?>" class="mt-2">
                                      <?php if ($row['foto_sktm']): ?>
                                        <?php $ext = strtolower(pathinfo($row['foto_sktm'], PATHINFO_EXTENSION)); ?>
                                        <?php if (in_array($ext, ['jpg','jpeg','png'])): ?>
                                          <img src="<?= $row['foto_sktm'] ?>" class="img-thumbnail" style="max-height:150px;">
                                        <?php elseif ($ext == 'pdf'): ?>
                                          <a href="<?= $row['foto_sktm'] ?>" target="_blank" class="btn btn-sm btn-primary">Lihat PDF</a>
                                        <?php endif; ?>
                                      <?php else: ?>
                                        <span class="text-muted">Belum ada file</span>
                                      <?php endif; ?>
                                    </div>
                                  </div>
                                  <div class="col-md-6">
                                    <label>Foto Rumah</label>
                                    <input type="file" class="form-control" name="foto_rumah"
                                           accept=".jpg,.jpeg,.png,.pdf" 
                                           onchange="previewFile(this, 'prevRumah<?= $row['id'] ?>')">
                                    <div id="prevRumah<?= $row['id'] ?>" class="mt-2">
                                      <?php if ($row['foto_rumah']): ?>
                                        <?php $ext = strtolower(pathinfo($row['foto_rumah'], PATHINFO_EXTENSION)); ?>
                                        <?php if (in_array($ext, ['jpg','jpeg','png'])): ?>
                                          <img src="<?= $row['foto_rumah'] ?>" class="img-thumbnail" style="max-height:150px;">
                                        <?php elseif ($ext == 'pdf'): ?>
                                          <a href="<?= $row['foto_rumah'] ?>" target="_blank" class="btn btn-sm btn-primary">Lihat PDF</a>
                                        <?php endif; ?>
                                      <?php else: ?>
                                        <span class="text-muted">Belum ada file</span>
                                      <?php endif; ?>
                                    </div>
                                  </div>
                                  <div class="col-md-6">
                                    <label>File Tanah</label>
                                    <input type="file" class="form-control" name="file_tanah"
                                           accept=".jpg,.jpeg,.png,.pdf" 
                                           onchange="previewFile(this, 'prevTanah<?= $row['id'] ?>')">

                                    <div id="prevTanah<?= $row['id'] ?>" class="mt-2">
                                      <?php if ($row['file_tanah']): ?>
                                        <?php $ext = strtolower(pathinfo($row['file_tanah'], PATHINFO_EXTENSION)); ?>
                                        <?php if (in_array($ext, ['jpg','jpeg','png'])): ?>
                                          <img src="<?= $row['file_tanah'] ?>" class="img-thumbnail" style="max-height:150px;">
                                        <?php elseif ($ext == 'pdf'): ?>
                                          <a href="<?= $row['file_tanah'] ?>" target="_blank" class="btn btn-sm btn-primary">Lihat PDF</a>
                                        <?php endif; ?>
                                      <?php else: ?>
                                        <span class="text-muted">Belum ada file</span>
                                      <?php endif; ?>
                                    </div>
                                  </div>
                                </div>
                              </div>
                              <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button><button type="submit" name="ubah" class="btn btn-warning">Simpan Perubahan</button></div>
                            </form>
                          </div>
                        </div>
                      </div>
                      <?php
                      // Modal Hapus
                      ?>
                      <div class="modal fade" id="modalHapus<?=$row['id']?>" tabindex="-1">
                        <div class="modal-dialog">
                          <div class="modal-content">
                            <form method="post">
                              <div class="modal-header bg-danger text-white">
                                <h5 class="modal-title">Hapus Data</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                              </div>
                              <div class="modal-body">
                                <input type="hidden" name="id" value="<?=$row['id']?>">
                                Yakin ingin menghapus data <strong><?=$row['nama']?></strong>?
                              </div>
                              <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                <button type="submit" name="hapus" class="btn btn-danger">Hapus</button>
                              </div>
                            </form>
                          </div>
                        </div>
                      </div>
                      <?php
                    }
                    ?>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </main>
      </div>
    </div>

<!-- Modal Tambah -->
<div class="modal fade" id="modalTambah" tabindex="-1">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <form method="POST" enctype="multipart/form-data">
        <div class="modal-header bg-primary text-white">
          <h5 class="modal-title" id="modalTambahLabel">Tambah Data</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
          <div class="row g-2">
            <div class="col-md-4"><label>NIK</label><input type="text" name="nik" class="form-control"></div>
            <div class="col-md-8"><label>Nama</label><input type="text" name="nama" class="form-control"></div>
            <div class="col-md-3">
              <label>Dusun</label>
              <select name="dusun" id="dusunTambah" class="form-select" required>
                <option value="">-- Pilih Dusun --</option>
                <option value="Manis">Manis</option>
                <option value="Pahing">Pahing</option>
                <option value="Puhun">Puhun</option>
                <option value="Wage">Wage</option>
                <option value="Kliwon">Kliwon</option>
              </select>
            </div>
            <div class="col-md-2">
              <label>RT</label>
              <select name="rt" id="rtTambah" class="form-select" required>
                <option value="">-- Pilih RT --</option>
              </select>
            </div>
            <div class="col-md-1">
              <label>RW</label>
              <input type="text" name="rw" id="rwTambah" class="form-control" readonly>
            </div>
            <div class="col-md-3">
              <label>SHDK</label>
              <select name="shdk" class="form-select">
                <option>Kepala Keluarga</option><option>Suami</option><option>Istri</option><option>Anak</option>
                <option>Menantu</option><option>Cucu</option><option>Orang Tua</option><option>Mertua</option>
                <option>Famili Lain</option><option>Pembantu</option><option>Lainnya</option>
              </select>
            </div>
            <div class="col-md-3"><label>HP</label><input type="text" name="hp" class="form-control"></div>
            <div class="col-md-3">
              <label>UMKM</label>
              <select name="umkm" class="form-select">
                <option>Tidak</option>
                <option>Ya</option>
              </select>
            </div>
            <div class="col-md-3"><label>Keterangan UMKM</label><input type="text" name="ketumkm" class="form-control"></div>
            <div class="col-md-3">
              <label>SKTM</label>
              <select name="sktm" class="form-select">
                <option>Tidak Ada</option>
                <option>Ada</option>
              </select>
            </div>
            <div class="col-md-3">
              <label>Status Rumah</label>
              <select name="srumah" class="form-select">
                <option>Pribadi</option>
                <option>Sewa</option>
              </select>
            </div>
            <div class="col-md-6">
              <label>Listrik</label>
              <select name="listrik" class="form-select">
                <option>Belum Memiliki kWh/Menyalur</option>
                <option>Belum Berlistrik</option>
              </select>
            </div>
            <div class="col-md-3"><label>Latitude</label><input type="text" name="lat" class="form-control"></div>
            <div class="col-md-3"><label>Longitude</label><input type="text" name="long" class="form-control"></div>
            <div class="col-md-3">
              <label>Status Tanah</label>
              <select name="stanah" class="form-select">
                <option>SHM</option>
                <option>>SPPT</option>
              </select>
            </div>
            <div class="col-md-3"><label>Jarak ke Tiang</label><input type="text" name="jtiang" class="form-control"></div>
            <div class="col-md-3"><label>Jarak ke Rumah ber kWh</label><input type="text" name="jrumah" class="form-control"></div>
            <div class="col-md-3">
              <label>Cek</label>
              <select name="cek" class="form-select">
                <option>Belum</option>
                <option>Sudah</option>
              </select>
            </div>
            <div class="col-md-12"><label>Keterangan</label><textarea name="ket" class="form-control"></textarea></div>

            <div class="col-md-6">
              <label>Foto KTP</label>
              <input type="file" name="foto_ktp" class="form-control" accept=".jpg,.jpeg,.png,.pdf" onchange="previewFile(this, 'previewKTP')">
              <div id="previewKTP" class="mt-2"></div>
            </div>
            <div class="col-md-6">
              <label>Foto SKTM</label>
              <input type="file" name="foto_sktm" class="form-control" accept=".jpg,.jpeg,.png,.pdf" onchange="previewFile(this, 'previewSKTM')">
              <div id="previewSKTM" class="mt-2"></div>
            </div>
            <div class="col-md-6">
              <label>Foto Rumah</label>
              <input type="file" name="foto_rumah" class="form-control" accept=".jpg,.jpeg,.png,.pdf" onchange="previewFile(this, 'previewRumah')">
              <div id="previewRumah" class="mt-2"></div>
            </div>
            <div class="col-md-6">
              <label>File Tanah</label>
              <input type="file" name="file_tanah" class="form-control" accept=".jpg,.jpeg,.png,.pdf"onchange="previewFile(this, 'previewTanah')">
              <div id="previewTanah" class="mt-2"></div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
          <button type="submit" name="tambah" class="btn btn-primary">Simpan</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
<script>
    const sidebar = document.getElementById('sidebar');
    const content = document.getElementById('content');
    const toggleBtn = document.getElementById('sidebarToggle');

    toggleBtn.addEventListener('click', () => {
      sidebar.classList.toggle('show');
    });

    // Ganti active menu saat diklik
    document.querySelectorAll('.sidebar .nav-link').forEach(link => {
      link.addEventListener('click', function() {
        document.querySelectorAll('.sidebar .nav-link').forEach(l => l.classList.remove('active'));
        this.classList.add('active');
      });
    });
  </script>
<script>
  $(document).ready(function(){
    $('#tabel').DataTable({responsive : true, pageLength: 25});
    <?php if(isset($_GET['status'])): ?>
      Swal.fire({
        icon: 'success',
        title: 'Berhasil',
        text: 'Data berhasil <?=$_GET['status']?>'
      });
    <?php endif; ?>
      document.getElementById("toggleSidebar").addEventListener("click", function () {
      document.getElementById("sidebar").classList.toggle("active");
    });
  });
</script>
<script>
function previewFile(input, previewId) {
    let file = input.files[0];
    let preview = document.getElementById(previewId);
    preview.innerHTML = ""; // reset isi preview

    if (file) {
        let ext = file.name.split('.').pop().toLowerCase();
        if (['jpg', 'jpeg', 'png'].includes(ext)) {
            let reader = new FileReader();
            reader.onload = function(e) {
                preview.innerHTML = `<img src="${e.target.result}" 
                                      class="img-thumbnail" 
                                      style="max-height:150px;">`;
            }
            reader.readAsDataURL(file);
        } else if (ext === 'pdf') {
            let url = URL.createObjectURL(file);
            preview.innerHTML = `<a href="${url}" target="_blank" class="btn btn-sm btn-primary">
                                    Lihat PDF
                                 </a>`;
        } else {
            preview.innerHTML = `<span class="text-danger">Format file tidak didukung!</span>`;
        }
    }
}
</script>

<script>
const dusunRTMapping = {
  "Manis": {rt: ["001","002","003","004","005","006","007"], rw:"001"},
  "Pahing": {rt: ["008","009","010","011","012"], rw:"002"},
  "Puhun": {rt: ["013","014","015","016","017","018","019"], rw:"003"},
  "Wage": {rt: ["020","021","022","023","024"], rw:"004"},
  "Kliwon": {rt: ["025","026","027","028","029","030","031","032"], rw:"005"}
};

// Tambah
document.getElementById("dusunTambah").addEventListener("change", function(){
  let dusun = this.value;
  let rtSelect = document.getElementById("rtTambah");
  let rwInput = document.getElementById("rwTambah");
  rtSelect.innerHTML = '<option value="">-- Pilih RT --</option>';
  if(dusun && dusunRTMapping[dusun]){
    dusunRTMapping[dusun].rt.forEach(rt=>{
      rtSelect.innerHTML += `<option value="${rt}">${rt}</option>`;
    });
    rwInput.value = dusunRTMapping[dusun].rw;
  } else {
    rwInput.value = "";
  }
});

// Ubah (loop untuk setiap row)
<?php foreach($result as $row): ?>
document.getElementById("dusunUbah<?= $row['id']; ?>").addEventListener("change", function(){
  let dusun = this.value;
  let rtSelect = document.getElementById("rtUbah<?= $row['id']; ?>");
  let rwInput = document.getElementById("rwUbah<?= $row['id']; ?>");
  rtSelect.innerHTML = '<option value="">-- Pilih RT --</option>';
  if(dusun && dusunRTMapping[dusun]){
    dusunRTMapping[dusun].rt.forEach(rt=>{
      rtSelect.innerHTML += `<option value="${rt}" ${rt=="<?= $row['rt']; ?>"?"selected":""}>${rt}</option>`;
    });
    rwInput.value = dusunRTMapping[dusun].rw;
  } else {
    rwInput.value = "";
  }
});
<?php endforeach; ?>
</script>

  </body>
</html>
